/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogSearchResult.java,v 1.4 2009/08/12 13:44:04 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;

/**
 * <p>TestLogSearchResult.java</p>
 * 
 * 
 * @author  Bianca Xue Jiang 
 * @author  Paul E. Slauenwhite
 * @version August 11, 2009
 * @since   March 15, 2006
 */
public class TestLogSearchResult extends AbstractTextSearchResult {

	private TestLogSearchQuery query;
	
	public TestLogSearchResult(TestLogSearchQuery sQuery) {
		super();
		this.query = sQuery;
	}

	public IEditorMatchAdapter getEditorMatchAdapter() {
		// TODO Auto-generated method stub
		return null;
	}

	public IFileMatchAdapter getFileMatchAdapter() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getLabel() {
		
		int matchCount = (getElements() == null ? 0 : getElements().length);
		String message = UiPluginResourceBundle.TestLogSearch_ResultLabelMatches;
		
		if(matchCount == 1){
			message = UiPluginResourceBundle.TestLogSearch_ResultLabelMatch;
		}
		
		return (NLS.bind(message, new String[]{query.getSearchQueryText(), String.valueOf(matchCount), query.getTestLogName()}));
	}

	public String getTooltip() {
		// TODO Auto-generated method stub
		return null;
	}

	public ImageDescriptor getImageDescriptor() {
		return TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_EXECUTION);
	}

	public ISearchQuery getQuery() {
		return query;
	}

}
