/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogSearchResultPage.java,v 1.1 2006/03/15 20:25:08 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EventLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TestLogSearchResultPage extends AbstractTextSearchViewPage implements
		IAdaptable {

	private ILogResultContentProvider contentProvider;
	private TestLogViewer editor;
	
	public TestLogSearchResultPage(int supportedLayouts) {
		super(supportedLayouts);
		// TODO Auto-generated constructor stub
	}

	public TestLogSearchResultPage() {
		super();
		// TODO Auto-generated constructor stub
	}

	protected void elementsChanged(Object[] objects) {
		if(contentProvider != null)
			contentProvider.elementsChanged(objects);
	}

	protected void clear() {
		if(contentProvider != null)
			contentProvider.clear();
	}

	protected void configureTreeViewer(TreeViewer viewer) {
		viewer.setUseHashlookup(true);
		viewer.setLabelProvider(new EventLabelProvider());
		viewer.setContentProvider(new LogResultTreeContentProvider(viewer));
		//viewer.setSorter(sorter);
		contentProvider = (ILogResultContentProvider)viewer.getContentProvider();
	}

	protected void configureTableViewer(TableViewer viewer) {
		viewer.setUseHashlookup(true);
		viewer.setLabelProvider(new EventLabelProvider());
		viewer.setContentProvider(new LogResultTableContentProvider(this));
		//viewer.setSorter(sorter);
		contentProvider = (ILogResultContentProvider)viewer.getContentProvider();
	}

	public Object getAdapter(Class adapter) {
		// TODO Auto-generated method stub
		return null;
	}

	public StructuredViewer getViewer()
	{
		return super.getViewer();
	}
	
	public void setInput(ISearchResult search, Object viewState) {
		super.setInput(search, viewState);
		if(search != null)
		{
			IEditorInput editorInput = ((TestLogSearchQuery)search.getQuery()).getEditorInput();
			if(editorInput != null)
			{
				IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
				if(workbenchPage != null)
				{
					IEditorPart editorPart = workbenchPage.findEditor(editorInput);
					if(editorPart instanceof TestLogViewer)
						this.editor = (TestLogViewer)editorPart;
					
					// workaround before can save matches in memory.
					// remove result when editor closed
					workbenchPage.addPartListener(new IPartListener(){
						public void partClosed(IWorkbenchPart part) {
							setInput(null, null);
						}
						public void partActivated(IWorkbenchPart part) {}
						public void partBroughtToTop(IWorkbenchPart part) {}
						public void partDeactivated(IWorkbenchPart part) {}
						public void partOpened(IWorkbenchPart part) {}
					});
				}
			}
		}
	}
	
	protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
		if(editor != null)
			editor.selectReveal(match.getElement());
		
	}
}
