/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimedEventSearchProvider.java,v 1.7 2007/05/03 17:33:36 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.swt.widgets.Composite;

/**
 * Search provider class for Timed Event element in Test Log Search.
 * 
 * @see extension point "org.eclipse.hyades.test.ui.testLogSearchProvider"
 * @see org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider
 * @author bjiang
 * @since 4.2
 */
public class TimedEventSearchProvider extends ExecutionEventSearchProvider 
{
	public void createContents(Composite parent) 
	{
		super.createContents(parent);
	}
	
	public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) 
	{
		SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);		
		
		setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFTimedEvent());
		LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
		LogicalExpression or = createORExpression();
		
		combineExecutionEventAndElementExpressions(query, executionEventOR, or);
		
		return query;
	}

}
