/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypedEventSearchProvider.java,v 1.7 2007/05/03 17:34:01 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * Search provider class for Typed Event element in Test Log Search.
 * 
 * @see extension point "org.eclipse.hyades.test.ui.testLogSearchProvider"
 * @see org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider
 * @author bjiang
 * @since 4.2
 */
public class TypedEventSearchProvider extends ExecutionEventSearchProvider implements SelectionListener
{
	private boolean searchStart;
	private Button start;
	private boolean searchStop;
	private Button stop;
	
	public void createContents(Composite parent) 
	{
		super.createContents(parent);
		
		Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
		group.setText(UiPluginResourceBundle.TestLogSearch_LimitToTypes); 
		group.setLayoutData(new GridData());
		group.setLayout(new GridLayout(2, true));
		
		start = new Button(group, SWT.CHECK);
		start.setText(TPFExecutionType.START_LITERAL.getLabel()); //$NON-NLS-1$
		start.addSelectionListener(this);
		stop = new Button(group, SWT.CHECK);
		stop.setText(TPFExecutionType.STOP_LITERAL.getLabel()); //$NON-NLS-1$
		stop.addSelectionListener(this);
	}
	
	public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) 
	{
		SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);		
		
		setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFTypedEvent());
		LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
		LogicalExpression or = createORExpression();
		
		if(searchStart)
		{
			BinaryExpression startSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFTypedEvent_Type(), 
										TPFExecutionType.START_LITERAL.toString());
			or.getArguments().add(startSearch);
		}
		if(searchStop)
		{
			BinaryExpression stopSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFTypedEvent_Type(), 
						TPFExecutionType.STOP_LITERAL.toString());
			or.getArguments().add(stopSearch);
		}
		
		combineExecutionEventAndElementExpressions(query, executionEventOR, or);
		
		return query;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {		
		if(e.widget == start)
			searchStart = start.getSelection();
		else if(e.widget == stop)
			searchStop = stop.getSelection();
		
		super.widgetSelected(e);
	}
}
