/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VerdictEventSearchProvider.java,v 1.7 2007/05/03 17:34:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * Search provider class for Verdict Event element in Test Log Search.
 * 
 * @see extension point "org.eclipse.hyades.test.ui.testLogSearchProvider"
 * @see org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider
 * @author bjiang
 * @since 4.2
 */
public class VerdictEventSearchProvider extends ExecutionEventSearchProvider {
	
	private boolean searchPass;
	private Button pass;
	private boolean searchFail;
	private Button fail;
	private boolean searchError;
	private Button error;
	private boolean searchInconclusive;
	private Button inconclusive;

	public void createContents(Composite parent) {
		super.createContents(parent);
		
		Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
		group.setText(UiPluginResourceBundle.TestLogSearch_LimitToVerdicts); 
		group.setLayoutData(new GridData());
		group.setLayout(new GridLayout(2, true));
		pass = new Button(group, SWT.CHECK);
		pass.setText(TPFVerdict.PASS_LITERAL.getLabel()); //$NON-NLS-1$
		pass.addSelectionListener(this);
		fail = new Button(group, SWT.CHECK);
		fail.setText(TPFVerdict.FAIL_LITERAL.getLabel()); //$NON-NLS-1$
		fail.addSelectionListener(this);
		error = new Button(group, SWT.CHECK);
		error.setText(TPFVerdict.ERROR_LITERAL.getLabel()); //$NON-NLS-1$
		error.addSelectionListener(this);
		inconclusive = new Button(group, SWT.CHECK);
		inconclusive.setText(TPFVerdict.INCONCLUSIVE_LITERAL.getLabel()); //$NON-NLS-1$
		inconclusive.addSelectionListener(this);
	}
	
	public SimpleSearchQuery createSearchQuery(EObject rootElement, String searchText, Map options) 
	{
		SimpleSearchQuery query = super.createSearchQuery(rootElement, searchText, options);		
		
		setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent());
		LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
		LogicalExpression or = createORExpression();
		
		if(searchPass)
		{
			BinaryExpression passSearch = createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent_Verdict(), TPFVerdict.PASS_LITERAL.toString());
			or.getArguments().add(passSearch);
		}
		if(searchFail)
		{
			BinaryExpression failSearch = createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent_Verdict(), TPFVerdict.FAIL_LITERAL.toString());
			or.getArguments().add(failSearch);
		}
		if(searchError)
		{
			BinaryExpression errorSearch = createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent_Verdict(), TPFVerdict.ERROR_LITERAL.toString());
			or.getArguments().add(errorSearch);
		}
		if(searchInconclusive)
		{
			BinaryExpression inclSearch = createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent_Verdict(), TPFVerdict.INCONCLUSIVE_LITERAL.toString());
			or.getArguments().add(inclSearch);
		}

		combineExecutionEventAndElementExpressions(query, executionEventOR, or);
		
		return query;
	}
	
	public void widgetSelected(SelectionEvent e) {
		
		if(e.widget == pass)
			searchPass = pass.getSelection();
		else if(e.widget == fail)
			searchFail = fail.getSelection();
		else if(e.widget == error)
			searchError = error.getSelection();
		else if(e.widget == inconclusive)
			searchInconclusive = inconclusive.getSelection();
			
		super.widgetSelected(e);
	}
}
