/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FixedSizeJobPool.java,v 1.3 2007/04/26 18:50:08 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.hyades.ui.util.IDisposable;

public class FixedSizeJobPool implements IDisposable {

	private int maxJobs;
	private int runningJobs = 0;
	private List queue = Collections.synchronizedList(new LinkedList());
	private Object lock = new Object();
	private boolean disposed;
	
	public FixedSizeJobPool(int maxJobs) {
		this.maxJobs = maxJobs;
	}
	
	public void scheduleJob(Job job) {
		queue.add(job);
		synchronized(lock) {
			if (runningJobs < maxJobs) {
				doScheduleJob();
			}
		}
	}
	
	private void doScheduleJob() {
		if (disposed) return;
		if (!queue.isEmpty()) {
			Job job = (Job)queue.remove(0);
			job.addJobChangeListener(jobListener);
			runningJobs++;
			job.schedule();
		}
	}
	
	private IJobChangeListener jobListener = new JobChangeAdapter() {

		public void done(IJobChangeEvent event) {
			if (event.getResult() != null) {
				synchronized(lock) {
					runningJobs--;
					doScheduleJob();
				}
			}
		}
		
	};
	
	public void dispose() {
		disposed = true;
	}
	
}
