/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ReferenceDisplayUtils.java,v 1.2 2009/05/28 16:12:58 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.util;

import java.util.Collection;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;

/**
 * this class provide a way for developers to visually check the relationship between proxy 
 * @author jbozier
 * @version May 27, 2009
 */
public class ReferenceDisplayUtils {
	private static final String basis = "--";//$NON-NLS-1$
	private static final String owned = "==";//$NON-NLS-1$
	private static final String opposite = "<";//$NON-NLS-1$
	private static final String direct = ">";//$NON-NLS-1$
	private static final String implicitStart = "[";//$NON-NLS-1$
	private static final String implicitEnd = "]";//$NON-NLS-1$
	private static ReferenceTypeRegistry factory = ReferenceTypeRegistry.getInstance();
	
	/**
	 * return a readable representation of a reference based on its type :
	 * --> explicit direct link
	 * <-- explicit opposite link
	 * ==> "owns" link
	 * [-->] implicit link
	 * @param type : type of the reference
	 * @return : a readable representation of a reference based on its type 
	 */
	public static String referenceToString(String type ) {
		StringBuffer buff = new StringBuffer();
		String oppositeRef = factory.getOppositeReferenceType(type);
		if (oppositeRef != null) {
			boolean implicit = (!factory.isExplicit(oppositeRef));
			if (implicit) {
				buff.append(implicitStart);
			}
			buff.append(opposite);
			if (factory.owns(oppositeRef)) {
				buff.append(owned);
			} else {
				buff.append(basis);
			}
			if (implicit) {
				buff.append(implicitEnd);
			}
		}
		boolean implicit = (!factory.isExplicit(type));
		if (implicit) {
			buff.append(implicitStart);
		}
		if (factory.owns(type)) {
			buff.append(owned);
		} else {
			buff.append(basis);
		}
		if (implicit) {
			buff.append(implicitEnd);
		}
		buff.append(direct);
		return buff.toString();
	}
	
	/**
	 * return all files that have references in target project
	 */
	public static Set getProjectReferenceFiles(IProject project) {
		return ReferenceRegistry.getInstance().getProjectReferenceRegistry(project).getReferencerFiles();
	}

	/**
	 * return all types of reference of a file in a target project
	 */
	public static Set getReferenceTypes(IProject project,IFile file) {
		return ReferenceRegistry.getInstance().getProjectReferenceRegistry(project).getReferenceTypes(file);
	}

	/**
	 * return all reference of a file of a given type in a target project
	 */
	public static Collection getReference(IProject project,IFile file,String type) {
		return ReferenceRegistry.getInstance().getProjectReferenceRegistry(project).getReferences(file, type);
	}

}
