/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SpecialFieldsBidiListener.java,v 1.3 2007/05/02 19:35:48 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.util;

import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;

/**
 * Generic Bidi Segment Listener for specific text fields, such as path
 * or package fields. This class can be either instantiated with custom segment
 * delimiters, or with pre-defined delimiters for a specific usage.
 * @author jcanches
 * @since 4.2.1
 */
public class SpecialFieldsBidiListener implements BidiSegmentListener {

	private String delimiters;
	
	public SpecialFieldsBidiListener(String delimiters) {
		this.delimiters = delimiters;
	}
	
	public void lineGetSegments(BidiSegmentEvent event) {
		String text = event.lineText;
		if (text == null) {
			// No need to zero event.segments (?)
			return;
		}
		int length = text.length();
		if (length < 2) {
			return;
		}
		int segments[] = new int[length + 1];
		int charIdx, segmentIdx;

		for (charIdx = 1, segmentIdx = 0; charIdx < length; charIdx++) {
			if (delimiters.indexOf(text.charAt(charIdx)) != -1) {
				segments[++segmentIdx] = charIdx;
			}
		}
		if (0 == segmentIdx) {
			// No delimiters found.
			return;
		}
		segments[0] = 0;
		segments[++segmentIdx] = length;
		if (++segmentIdx <= length) {
			event.segments = new int[segmentIdx];
			System.arraycopy(segments, 0, event.segments, 0, segmentIdx);
		} else {
			event.segments = segments;
		}
	}
	
	public static SpecialFieldsBidiListener createPackageFieldBidiListener() {
		return new SpecialFieldsBidiListener("."); //$NON-NLS-1$
	}
	
	public static SpecialFieldsBidiListener createPathFieldBidiListener() {
		return new SpecialFieldsBidiListener(".:\\/"); //$NON-NLS-1$
	}

}
