/********************************************************************** 
 * Copyright (c) 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: TestCaseInvocationDeleter.java,v 1.2 2009/10/23 18:15:14 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.core.util.IEMFCustomDeleter;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;

/**
 * special deleter to remove test invocation when test suite or test case is deleted
 * 
 * 
 * @author   Jerome Bozier
 * @version  October 23, 2009
 * @since    September 28, 2009
 */
 
public class TestCaseInvocationDeleter implements IEMFCustomDeleter {

	private static TestCaseInvocationDeleter instance = null;
	private IFileProxyManager proxManager = null;
	
	private TestCaseInvocationDeleter() {		
		EMFUtil.registerCustomDeleter(this);
	}
	
	public static TestCaseInvocationDeleter getInstance() {
		if (instance == null) {
			instance = new TestCaseInvocationDeleter();
		}
		return instance;
	}
	
	public void customDelete(EObject eobject) {
		if (eobject instanceof TPFTestCase) {
			customDelete((TPFTestCase)eobject);
			return;
		}
		if (eobject instanceof TPFTestSuite) {
			customDelete((TPFTestSuite)eobject);
			return ;
		}
	}
	
	public void customDelete(TPFTestSuite testSuite) {			
		for (Iterator it = testSuite.getITestCases().iterator(); it.hasNext(); ) {
			EObject eobject = (EObject)it.next();
			customDelete(eobject);
		}
	}
	
	public void customDelete(TPFTestCase testCase) {
		Set changedResources = new HashSet();
		TPFTestSuite ts = testCase.getTestSuite();
		// get active proxy manager
		if (proxManager == null) {
			proxManager = TestNavigator.getFileProxyManager();
			if (proxManager == null) {
				return;
			}
		}		
		IProxyNode prox = proxManager.getProxy((IFile)ts.getAdapter(IFile.class), null);
		EObjectProxyNode eproxy = null;
		if (prox instanceof EObjectProxyNode) {
			eproxy = (EObjectProxyNode)prox;
		} else {
			return;
		}
		Set allTypes = eproxy.getReferenceTypes();		
		for (Iterator it = allTypes.iterator(); it.hasNext(); ) {			
			String type = (String)it.next();
			if (type.equals("TestInvoked2TestInvoker")) {	
				Collection references = eproxy.getReferences(type);
				for (Iterator it2 = references.iterator(); it2.hasNext();) {
					IProxyNode proxy = (IProxyNode) it2.next();
					if (proxy instanceof ITestSuiteProxyNode) {
						ITestSuiteProxyNode tst2prox = (ITestSuiteProxyNode)proxy;
						TPFTestSuite testSuite = tst2prox.getTestSuite(); // care : getter return a different instance each time, so factorize the call
						TPFBehavior behav = testSuite.getBehavior();
						List toBeRemoved = new ArrayList();
						List allActions = behav.getInteraction().getActions();
						for (int cpt = 0; cpt < allActions.size(); cpt++) {
							BVRExecutionOccurrence call = (BVRExecutionOccurrence)allActions.get(cpt);
							ITest calledTest = call.getInvokedTest();
							if (calledTest.getId().equals(testCase.getId())) {
								allActions.remove(call);
								changedResources.add(testSuite.eResource());
								cpt --;
							}							
						}
					}
				}			
			}
		}
		if (changedResources.isEmpty()) {
			return;
		}
		for (Iterator i = changedResources.iterator(); i.hasNext();) {
			Resource resource = (Resource)i.next();
			try {
				EMFUtil.save(resource);
			} catch (Exception e) {
				UiPlugin.logError(e);
			}
		}
	}

}
