/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactNewWizard.java,v 1.17 2010/05/05 12:32:43 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.core.util.ArtifactUtil;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

/**
 * <p>Extension of the {@link HyadesNewWizard} wizard for creating artifacts.</p>
 * 
 * 
 * @author  Peter Sun
 * @author  Bianca Xue Jiang
 * @author  Tony Wang
 * @author  Jerome Bozier
 * @author  Paul E. Slauenwhite
 * @version May 4, 2010
 * @since   February 1, 2005
 */
public class ArtifactNewWizard extends HyadesNewWizard {
	
	private ArtifactSelectionPage artifactSelectionPage = null;
	private CFGArtifact newArtifact = null;
	private TestLocationPage testLocationPage = null;
	/**
	 * Constructor for LocationNewWizard
	 */
	public ArtifactNewWizard()
	{
		super();
		setWindowTitle(UiPluginResourceBundle.WIZ_ARTIFACT_TTL); 
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWARTIFACT));

		IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("AritfactNewWizard"); //$NON-NLS-1$
		if(settings == null)
			settings = dialogSettings.addNewSection("ArtifactNewWizard"); //$NON-NLS-1$
		setDialogSettings(settings);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getLocationPage()
	 */
	protected LocationPage getLocationPage() {
		
		if(testLocationPage == null){

			testLocationPage = new TestLocationPage("artifactLocation", selection); //$NON-NLS-1$

			String fileExtension = getFileExtension();
			
			if (fileExtension != null) {
				
				testLocationPage.setFileExtension(fileExtension);
				testLocationPage.setFileName(""); //$NON-NLS-1$
			}
		}

		return testLocationPage;
	}

	/**
	 * Returns the type for the datapool created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestUIExtension.GENERIC_ARTIFACT_TYPE;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	public String getFileExtension()
	{
		return ICommonConstants.ARTIFACT_FILE_EXTENSION;
	}


	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		super.initPages();
		artifactSelectionPage = new ArtifactSelectionPage("assetSelection"); //$NON-NLS-1$
	}

	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_TTL); 
		getLocationPage().setDescription(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_LOC_DSC); 
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_TTL); 
		getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_ATT_DSC); 
		addPage(getAttributeWizardPage());
		
		artifactSelectionPage.setTitle(UiPluginResourceBundle.WIZ_ARTIFACT_ASS_PG_TTL); 
		artifactSelectionPage.setDescription(UiPluginResourceBundle.WIZ_ARTIFACT_ASS_PG_DSC); 
		addPage(artifactSelectionPage);
		
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		Resource resource = createResource(file);
		resource.getContents().add(createEObject());
		EMFUtil.save(resource);
		return true;
	}
	
	/**
	 * Creates the EObject setting the attributes based on the information
	 * the user has defined in this wizard's pages.
	 * @return a not null EObject
	 */
	protected EObject createEObject(){
		
		newArtifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
		newArtifact.setName(getLocationPage().getFileNameWithoutExtension());		
		
		String description = getAttributeWizardPage().getItemDescription();
		
		if((description != null) && (description.trim().length() > 0)){
			newArtifact.setDescription(description);
		}

		IProxyNode[] selectedProxyNodes = artifactSelectionPage.getSelectedProxyNodes();
		
		if(selectedProxyNodes.length > 0){
						
			for (int counter = 0; counter < selectedProxyNodes.length; counter++) {
				
				if(selectedProxyNodes[counter] instanceof EObjectProxyNode){

					EObject eObject = ((EObjectProxyNode)(selectedProxyNodes[counter])).getEObject();
					
					if(eObject instanceof CFGClass){
						ArtifactUtil.associateTestAsset(((CFGClass)(eObject)), newArtifact);
					}
				}
			}			
		}
				
		return newArtifact;
	}
	
	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	protected Resource createResource(IFile file)
	{
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString(), false);
		Resource.Factory factory = EMFUtil.getResourceFactory(ICommonConstants.ARTIFACT_FILE_EXTENSION);
		return factory.createResource(uri);
	}

		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		
		//Attempt to open the editor:
		TestUIUtil.openEditor(file, TestUIExtension.ARTIFACT_EDITOR_PART_ID);
	}	
	
	public CFGArtifact getNewArtifact()
	{
		return this.newArtifact;
	}
	
}
