/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactSelectionPage.java,v 1.10 2009/05/17 16:16:08 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeSelectionViewer;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

/**
 * <p>Artifact selection page.</p>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @author      Peter Sun
 * @author      Jon Hoover
 * @version     May 16, 2009
 * @since       February 1, 2005
 */
public class ArtifactSelectionPage extends WizardPage {

	private String[] fileExtensions;
	private ProxyNodeSelectionViewer viewer;
	
	/**
	 * @param pageName
	 */
	protected ArtifactSelectionPage(String pageName) {
		super(pageName);
		fileExtensions = getSupportedFileExtensions();
	}

	private String[] getSupportedFileExtensions() {
		return new String[] { ICommonConstants.TEST_SUITE_FILE_EXTENSION,
				ICommonConstants.TEST_COMPONENT_EXTENSION,
				ICommonConstants.SUT_EXTENSION,
				ICommonConstants.DATAPOOL_FILE_EXTENSION };
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		
		Composite composite= new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(
			new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));

		PlatformUI.getWorkbench().getHelpSystem().setHelp(composite,UiPlugin.getID() + ContextIds.ART_WIZ);
		
		viewer = new ProxyNodeSelectionViewer(composite,
					ResourcesPlugin.getWorkspace().getRoot(),
					fileExtensions,
					SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER);
			
		setControl(composite);
	}

	/**
	 * @see org.eclipse.jface.dialogs.DialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {
		
		super.setVisible(visible);
		
		if (visible) {
			viewer.getViewer().getTree().setFocus();
		}
	}
	
	public IProxyNode[] getSelectedProxyNodes(){
		return (viewer.getSelectedProxyNodes());
	}
}