/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolExportCSVFileLocationPage.java,v 1.11 2010/02/03 13:57:16 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.Locale;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * <p>This wizard page is the first page used in the Export Datapool wizard.
 * It allows the user to select a CSV file and different export options.</p>
 * 
 * 
 * @author  Peter Sun
 * @author  Paul E. Slauenwhite
 * @version February 3, 2010
 * @since   February 1, 2005
 */
public class DatapoolExportCSVFileLocationPage extends WizardPage {

	private CSVFileSelectionComposite csvFileSelectionComposite = null;
	
    protected DatapoolExportCSVFileLocationPage(String pageName) {
        super(pageName);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.DialogPage#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
        
    	super.setVisible(visible);
        
    	if (visible) {
    		csvFileSelectionComposite.getCSVFilePathText().setFocus();
        }
    }
    
    /* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent){
		
		SelectionAdapter selectionAdapter = new SelectionAdapter(){

			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e){
				validateSelection();
			}
		};
		
		csvFileSelectionComposite = new CSVFileSelectionComposite(parent, SWT.NONE, UiPluginResourceBundle.WIZ_EXP_DATAPOOL_CSV_PG_TAG);
		csvFileSelectionComposite.setLayoutData(GridDataUtil.createHorizontalFill());
		csvFileSelectionComposite.setLayout(new GridLayout(3, false));
		csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().addSelectionListener(selectionAdapter);
		csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().addSelectionListener(selectionAdapter);
		csvFileSelectionComposite.getCSVFileCellsEnclosedInXMLTagsButton().addSelectionListener(selectionAdapter);
		csvFileSelectionComposite.getCSVFilePathText().addModifyListener(new ModifyListener(){
		
			public void modifyText(ModifyEvent e) {
				validateSelection();
			}
		});
		
		setControl(csvFileSelectionComposite);
		
		setPageComplete(false);
	}

	public String getCSVFilePath(){
		return (csvFileSelectionComposite.getCSVFilePathText().getText());
	}
	
	public boolean getCSVFileFirstRowContainsVariableNames(){
		return (csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().getSelection());
	}
	
	public boolean getCSVFileFirstColumnContainsEquivalenceClassNames(){
		return (csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().getSelection());
	}

	public boolean getCSVFileCellsEnclosedInXMLTags(){
		return (csvFileSelectionComposite.getCSVFileCellsEnclosedInXMLTagsButton().getSelection());
	}

	public String getCSVFileEncoding(){		
		return (CSVFileSelectionComposite.ENCODING_VALUES[csvFileSelectionComposite.getCSVFileEncodingCombo().getSelectionIndex()]);
	}

    protected boolean validateSelection() {
    	
    	//Note: The error message is not initially reset to reduce flicker when setting the same error message.		
		boolean isValid = false;
        String csvFilePath = getCSVFilePath();
        IPath csvFileIPath = new Path(csvFilePath);
        
        if ((csvFilePath.trim().length() == 0) || (!csvFileIPath.removeLastSegments(1).toFile().exists())) {
        	setErrorMessage(UiPluginResourceBundle.DatapoolExportPage_ERROR_MISSING_CSV_DIRECTORY);
        } 
        
        //Note: The CSV file extension (TestUI.CSV_FILE_EXTENSION) is in lower-case.
        else if ((csvFileIPath.getFileExtension() == null) || (!csvFileIPath.getFileExtension().toLowerCase(Locale.ENGLISH).equals(TestUI.CSV_FILE_EXTENSION))) {
        	setErrorMessage(UiPluginResourceBundle.DatapoolExportPage_ERROR_MISSING_CSV_FILE_EXTENSION);
        } 
        else {
        	
        	setErrorMessage(null);
            isValid = true;
        }
        
        setPageComplete(isValid);

        return isValid;
    }
}
