/*******************************************************************************
 * Copyright (c) 2008, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolImportPageTwo.java,v 1.8 2010/03/30 18:34:56 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

/**
 * <p>Datapool import wizard second wizard page to import the selected CSV file 
 * into an existing datapool.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version March 30, 2010
 * @since   October 31, 2008
 */
public class DatapoolImportPageTwo extends DatapoolSelectionPage {

	private Button useExistingDatapoolButton = null;
	private Button replaceExistingRecordsButton = null;
	
	public DatapoolImportPageTwo(String name, IStructuredSelection selection){		
		super(name, selection);
	}
	
	/* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.DialogPage#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
        
    	super.setVisible(visible);
        
    	if (visible){
    		
    		if(getSelectedDatapool() != null){
    			
    			if(isSelectedDatapoolEncrypted()){
        			encryptedDatapoolPasswordText.setFocus();
    			}
    			else{
    				datapoolSelectionViewer.getViewer().getTree().setFocus();
    			}
    		}    	
    		else {
    			useExistingDatapoolButton.setFocus();
    		}
        }
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.wizard.DatapoolSelectionPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		
		Composite pane = new Composite(parent, SWT.SHADOW_NONE);
		pane.setLayout(new GridLayout());
		pane.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
			    
		useExistingDatapoolButton = new Button(pane, SWT.CHECK);
		useExistingDatapoolButton.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_useExistingButton);	  
	
		final Group exisitingDatapoolGroup = new Group(pane, SWT.SHADOW_ETCHED_IN);
		exisitingDatapoolGroup.setLayout(new GridLayout());
		exisitingDatapoolGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		exisitingDatapoolGroup.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_datapoolsGroup);
		
		super.createControl(exisitingDatapoolGroup);

		final Group existingRecordsGroup = new Group(pane, SWT.SHADOW_ETCHED_IN);
		existingRecordsGroup.setLayout(new GridLayout());
		existingRecordsGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		existingRecordsGroup.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_recordsGroup);

		useExistingDatapoolButton.addSelectionListener(new SelectionAdapter() {
			
	    	public void widgetSelected(SelectionEvent e) {
	    		
	    		boolean isEnabled = useExistingDatapoolButton.getSelection();
	    		
	    		TestUIUtilities.setEnabled(existingRecordsGroup, isEnabled);
	    		TestUIUtilities.setEnabled(exisitingDatapoolGroup, isEnabled);
	    		
	    		if((isEnabled) && (getSelectedDatapool() != null)){

	    			if(isSelectedDatapoolEncrypted()){
	        			encryptedDatapoolPasswordText.setFocus();
	    			}
	    			else{
	    				datapoolSelectionViewer.getViewer().getTree().setFocus();
	    			}
	    		}    
	    		
	    		setPageComplete(validatePage());
			}
		});

		Button appendToExistingRecordsButton = new Button(existingRecordsGroup, SWT.RADIO);
		appendToExistingRecordsButton.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_appendToExistingButton);	  
		appendToExistingRecordsButton.setSelection(true);
		appendToExistingRecordsButton.addSelectionListener(new SelectionAdapter() {
			
	    	public void widgetSelected(SelectionEvent e) {	    		
	    		setPageComplete(validatePage());
			}
		});

		replaceExistingRecordsButton = new Button(existingRecordsGroup, SWT.RADIO);
		replaceExistingRecordsButton.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_replaceExistingButton);	  
		replaceExistingRecordsButton.addSelectionListener(new SelectionAdapter() {
			
	    	public void widgetSelected(SelectionEvent e) {	    		
	    		setPageComplete(validatePage());
			}
		});

		TestUIUtilities.setEnabled(existingRecordsGroup, false);
		TestUIUtilities.setEnabled(exisitingDatapoolGroup, false);

		pane.layout(false, true);
	    				
		setControl(pane);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.wizard.DatapoolSelectionPage#getSelectedDatapool()
	 */
	public IDatapool getSelectedDatapool(){

		if(useExistingDatapoolButton.getSelection()){
			return (super.getSelectedDatapool());
		}
			
		return null;
	}
	
	public boolean isReplaceExistingRecords(){			

		if(useExistingDatapoolButton.getSelection()){
			return (replaceExistingRecordsButton.getSelection());
		}

		return false;
	}
	 
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.WizardPage#canFlipToNextPage()
	 */
	public boolean canFlipToNextPage() {		
		return (!useExistingDatapoolButton.getSelection());
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.wizard.DatapoolSelectionPage#validatePage()
	 */
	protected boolean validatePage() {
		
		//Note: The error message is not initially reset to reduce flicker when setting the same error message.		
		boolean isValid = false;
		
		//Validate only if using an existing datapool:
		if(useExistingDatapoolButton.getSelection()){

			//Validate the super class:
			if(super.validatePage()){

				//Resolve the selected datapool:
				IDatapool selectedDatapool = getSelectedDatapool();

				//Validate the selected datapool:
				if(selectedDatapool != null){

					Shell shell = getShell();
					
					//Set the wait cursor:
					shell.setCursor(new Cursor(shell.getDisplay(), SWT.CURSOR_WAIT));

					try {

						DatapoolImportPageOne datapoolImportPage = ((DatapoolImportWizard)(getWizard())).getDatapoolImportPageOne();

						//Validate the selected datapool with the CSV file:
						if(CSVImportExportUtil.getInstance().validateCSVFileWithDatapool(datapoolImportPage.getCSVFilePath(), selectedDatapool, datapoolImportPage.getCSVFileFirstRowContainsVariableNames(), datapoolImportPage.getCSVFileFirstColumnContainsEquivalenceClassNames(), isReplaceExistingRecords(), datapoolImportPage.getCSVFileEncoding())) {
							
							isValid = true;

							setErrorMessage(null);
						}
						else{
							setErrorMessage(UiPluginResourceBundle.DatapoolImportWizard_diffVariableInfoWarning);							
						}
					}
					catch(CorruptCSVFileException c) {
						setErrorMessage(c.getMessage());
					}	
					finally{
						
						//Set the default cursor:
						shell.setCursor(null);
					}
				}
			}
		}
		
		//Note: Page remains invalid to disable the Finish button (see canFlipToNextPage() to enable the Next button).
		//Reset the error message since not using an existing datapool:
		else{			
			setErrorMessage(null);	
		}
		
		return isValid;
	}
}
