/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentMapPage.java,v 1.6 2007/04/26 20:35:44 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DeploymentMapPage extends WizardPage implements SelectionListener, ISelectionChangedListener {

	TPFDeployment deployment = null;
	StructuredViewer artifactViewer = null;
	StructuredViewer locationViewer = null;
	StructuredViewer pairViewer = null;
	CFGArtifact selectedArtifact = null;
	CFGLocation selectedLocation = null;
	CFGArtifactLocationPair selectedPair = null;
	Button createPairButton = null;
	Button removeButton = null;
	Button upButton = null;
	Button downButton = null;
	
	/**
	 * @param pageName
	 */
	protected DeploymentMapPage(String pageName, TPFDeployment deployment) {
		super(pageName);
		this.deployment = deployment;
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) 
	{
		Composite composite = new Composite(parent, SWT.NONE);		
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		composite.setLayout(gridLayout);

		Composite artifactsColumn = createColumn(composite);
		Composite locationsColumn = createColumn(composite);
		artifactViewer = createViewer(artifactsColumn, deployment.getArtifacts());
		artifactViewer.getControl().getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = UiPluginResourceBundle.W_ARTIFACTS;
			}
		});
		locationViewer = createViewer(locationsColumn, deployment.getRefLocations());
		locationViewer.getControl().getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = UiPluginResourceBundle.W_LOCS;
			}
		});

		createPairButton = new Button(composite, SWT.PUSH);
		GridData buttonData = new GridData();
		buttonData.horizontalAlignment = GridData.CENTER;
		buttonData.horizontalSpan = 2;
		createPairButton.setLayoutData(buttonData);
		createPairButton.setToolTipText(UiPluginResourceBundle.BTN_CREATE_PAIR);
		createPairButton.setImage(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_DOWNARROW).createImage());
		createPairButton.setEnabled(false);
		createPairButton.addSelectionListener(this);
		createPairButton.getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = createPairButton.getToolTipText();
			}
		});

		Composite southComposite = new Composite(composite, SWT.NONE);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.horizontalSpan = 2;
		southComposite.setLayoutData(gridData);
		
		GridLayout southLayout = new GridLayout();
		southLayout.marginWidth = 0;
		southLayout.marginHeight = 0;
		southLayout.verticalSpacing = 10;
		southLayout.numColumns = 2;
		southComposite.setLayout(southLayout);
		
		pairViewer = createTableViewer(southComposite);	
		pairViewer.getControl().getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = UiPluginResourceBundle.EDT_DEP_PAIR;
			}
			public void getDescription(AccessibleEvent e) {
				e.result = UiPluginResourceBundle.EDT_DEP_PAIR;
			}
		});

		Composite buttonComposite = new Composite(southComposite, SWT.NONE);
		GridData data = new GridData();
		data.horizontalSpan = 2;
		data = new GridData(GridData.FILL_VERTICAL);
		buttonComposite.setLayoutData(data);
		GridLayout buttonLayout = new GridLayout();
		buttonLayout = new GridLayout();
		buttonLayout.marginWidth = 0;
		buttonLayout.marginHeight = 0;
		buttonLayout.numColumns = 1;
		buttonComposite.setLayout(buttonLayout);
		
		createButtons(buttonComposite);
		
		setControl(composite);
	}

	private void createButtons(Composite parent)
	{
		removeButton = new Button(parent, SWT.PUSH);
		removeButton.setText(UiPluginResourceBundle.label_Remove);
		GridData data = GridDataUtil.createHorizontalFill();
		removeButton.setLayoutData(data);
		removeButton.setEnabled(false);
		removeButton.addSelectionListener(this);

		upButton = new Button(parent, SWT.PUSH);
		upButton.setText(UiPluginResourceBundle.LBL_UP);
		data = GridDataUtil.createHorizontalFill();
		data.verticalAlignment = GridData.VERTICAL_ALIGN_END;
		upButton.setLayoutData(data);
		upButton.setEnabled(false);
		upButton.addSelectionListener(this);

		downButton = new Button(parent, SWT.PUSH);
		downButton.setText(UiPluginResourceBundle.LBL_DOWN);
		data = GridDataUtil.createHorizontalFill();
		data.verticalAlignment = GridData.VERTICAL_ALIGN_END;
		downButton.setLayoutData(data);
		downButton.setEnabled(false);
		downButton.addSelectionListener(this);
	}
	
	
	protected Composite createColumn(Composite parent)
	{
		Composite column =  new Composite(parent, SWT.NONE);
		column.setLayoutData(GridDataUtil.createFill());
		GridLayout gridLayout = new GridLayout();
		gridLayout.verticalSpacing = 10;
		gridLayout.marginWidth = 0;
		column.setLayout(gridLayout);
		return column;
	}

	protected StructuredViewer createViewer(Composite parent, Object input)
	{		
		Tree tree = new Tree(parent, SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER );
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 150;
		tree.setLayoutData(gridData);
				
		ObjectContentProvider contentProvider = new ObjectContentProvider();
		StructuredViewer objectViewer = new TreeViewer(tree);
		objectViewer.setContentProvider(contentProvider);
		objectViewer.setLabelProvider(new ObjectLabelProvider(true));
		objectViewer.addSelectionChangedListener(this);
		if(deployment != null)
			objectViewer.setInput(input);

		return objectViewer;
	}
	
	protected StructuredViewer createTableViewer(Composite parent)
	{
		Table table = new Table(parent, SWT.BORDER | SWT.FULL_SELECTION | SWT.SINGLE);
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 150;
		table.setLayoutData(gridData);
		table.setLinesVisible(true);
		table.setHeaderVisible(false);

		new TableColumn(table, SWT.LEFT);
		new TableColumn(table, SWT.LEFT);
			
		table.addControlListener( new ControlListener() {
			public void controlMoved(ControlEvent e) {}

			public void controlResized(ControlEvent e) 
			{
				if(e.getSource() instanceof Table)
				{
					Table table = ((Table)e.getSource());
					int width = table.getSize().x;
					int gridLineWidth = table.getGridLineWidth();
					TableColumn[] columns = table.getColumns();
					for(int i = 0; i < columns.length; i++)
						columns[i].setWidth((width - (columns.length * gridLineWidth) - 2)/columns.length);
				}

			}
		});
	
		ObjectContentProvider contentProvider = new ObjectContentProvider();
		StructuredViewer tableViewer = new TableViewer(table);
		tableViewer.setContentProvider(contentProvider);
		tableViewer.setLabelProvider(new MapLabelProvider());
		tableViewer.addSelectionChangedListener(this);
		if(deployment != null)
			tableViewer.setInput(deployment.getArtifactLocations());
		
		return tableViewer;
	}
		
	private class ObjectContentProvider implements ITreeContentProvider, IStructuredContentProvider
	{
		private ArrayList list = new ArrayList();
	
		public ObjectContentProvider()
		{ 
		}
		
		public void dispose()
		{
			list.clear();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement) {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
		 */
		public Object getParent(Object element) {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
		 */
		public boolean hasChildren(Object element) {
			return false;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) 
		{
			Object[] elements = new Object[0];
			if(inputElement == null)
				return elements;
			if(inputElement instanceof EList)
			{
				int listSize = ((EList)inputElement).size();
				elements = new Object[listSize];
				for(int i = 0; i < listSize; i++)
				{
					elements[i] = ((EList)inputElement).get(i);
				}
			}
			return elements;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			
		}

	}
	
	private class ObjectLabelProvider extends LabelProvider
	{
		private boolean useImages;
	
		/**
		 * Constructor for PerspectiveLabelProvider
		 */
		public ObjectLabelProvider(boolean useImages)
		{
			super();
			this.useImages = useImages;
		}
	
		/**
		 * @see LabelProvider#getImage(Object)
		 */
		public Image getImage(Object element)
		{
			if((!useImages) || (element == null))
				return null;

			if(element instanceof CFGArtifact)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ARTIFACT);

			if(element instanceof CFGLocation)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_LOCATION);

			if (element instanceof IAdaptable)
			{
				IWorkbenchAdapter adapter =
					(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

				if(adapter != null)
					return adapter.getImageDescriptor(element).createImage();
			}

			return null;			
		}

		/**
		 * @see LabelProvider#getText(Object)
		 */
		public String getText(Object element)
		{
			if(element == null)
				return "";

			String text = null;
		
			if(element instanceof CFGArtifact)
				text = ((CFGArtifact)element).getName();
			
			else if(element instanceof CFGLocation)
				text = ((CFGLocation)element).getName();
			
			else if(element instanceof IAdaptable)
			{
				IWorkbenchAdapter adapter =
					(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

				if(adapter != null)
					text = adapter.getLabel(element);
			}

			if(text == null)
				text = element.toString();
			
			return text;		
		}
		
	
		/**
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
		 */
		public void dispose()
		{
			super.dispose();
		}
	}

	private class MapLabelProvider extends LabelProvider implements ITableLabelProvider
	{
		/**
		 * @see ITableLabelProvider#getColumnImage(Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex)
		{

			return null;
		}
		/**
		 * @see ITableLabelProvider#getColumnText(Object, int)
		 */
		public String getColumnText(Object element, int columnIndex)
		{

			if (element instanceof CFGArtifactLocationPair)
			{
				CFGArtifactLocationPair pair = (CFGArtifactLocationPair)element;

				if (columnIndex == 0)
					return pair.getArtifact().getName();

				if (columnIndex == 1)
					return pair.getLocation().getName();

			}
			return new String();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) 
	{
		ISelection selection = event.getSelection();
		Object sel = null;
		if(selection != null && !selection.isEmpty())
		{ 
			sel = ((IStructuredSelection)selection).getFirstElement();
			if(sel != null && sel instanceof CFGArtifact)
				selectedArtifact = (CFGArtifact)sel;
			if(sel != null && sel instanceof CFGLocation)
				selectedLocation = (CFGLocation)sel;
			if(sel != null && sel instanceof CFGArtifactLocationPair)
				selectedPair = (CFGArtifactLocationPair)sel;
		}
		if(selectedArtifact != null && selectedLocation != null)
		{
			boolean enableButton = isPairUnique(deployment.getArtifactLocations(), selectedArtifact, selectedLocation);
			createPairButton.setEnabled(enableButton);
		}
		if(selectedPair != null)
		{
			int index = deployment.getArtifactLocations().indexOf(selectedPair);
			int maxIndex = deployment.getArtifactLocations().size() - 1;
			boolean enableUp = true;
			boolean enableDown = true;
			if(index == 0)
				enableUp = false;
			if(index == maxIndex)
				enableDown = false;
			removeButton.setEnabled(true);
			upButton.setEnabled(enableUp);
			downButton.setEnabled(enableDown);
			
		}
		else
		{
			removeButton.setEnabled(false);
			upButton.setEnabled(false);
			downButton.setEnabled(false);
		}
	
	}


	public void refresh() 
	{
		artifactViewer.refresh();
		locationViewer.refresh();
	}


	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) 
	{
		if (e.widget == createPairButton)
		{
			if(selectedArtifact != null && selectedLocation != null)
			{
				if(isPairUnique(deployment.getArtifactLocations(), selectedArtifact, selectedLocation))
				{
					CFGArtifactLocationPair newPair = Common_ConfigurationFactory.eINSTANCE.createCFGArtifactLocationPair();
					newPair.setArtifact(selectedArtifact);
					newPair.setLocation(selectedLocation);
					deployment.getArtifactLocations().add(newPair);
					pairViewer.refresh();
					createPairButton.setEnabled(false);
					return;
				}
			}
		}
		
		ISelection selection = pairViewer.getSelection();
		Object sel = null;
		if(selection != null && !selection.isEmpty())
		{ 
			sel = ((IStructuredSelection)selection).getFirstElement();
		}
		if (e.widget == removeButton)
		{
			if(selectedPair != null)
			{
				deployment.getArtifactLocations().remove(selectedPair);
				removeButton.setEnabled(false);
				upButton.setEnabled(false);
				downButton.setEnabled(false);
				selectedPair = null;
				pairViewer.refresh();
			}
			return;
		}
		if (e.widget == upButton)
		{
			int index = -1;
			if(sel != null && sel instanceof CFGArtifactLocationPair)
			{
				index = deployment.getArtifactLocations().indexOf((CFGArtifactLocationPair)sel);
				deployment.getArtifactLocations().move(index, index - 1);
				pairViewer.refresh();
				if(index - 1 == 0)
				{
					upButton.setEnabled(false);
					downButton.setEnabled(true);						
				}
				else
				{
					upButton.setEnabled(true);
					downButton.setEnabled(true);											
				}
			}
		}
		if (e.widget == downButton)
		{
			int index = -1;
			int maxIndex = -1;
			if(sel != null && sel instanceof CFGArtifactLocationPair)
			{
				index = deployment.getArtifactLocations().indexOf((CFGArtifactLocationPair)sel);
				maxIndex = deployment.getArtifactLocations().size() - 1;
				deployment.getArtifactLocations().move(index, index + 1);
				pairViewer.refresh();
				if(index + 1 == maxIndex)
				{
					upButton.setEnabled(true);
					downButton.setEnabled(false);						
				}
				else
				{
					upButton.setEnabled(true);
					downButton.setEnabled(true);											
				}
			}
		}
	}


	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	private boolean isPairUnique(EList list, CFGArtifact artifact, CFGLocation location)
	{
		for(int i = 0; i < list.size(); i++)
		{
			CFGArtifactLocationPair pair = (CFGArtifactLocationPair)list.get(i);
			if(pair.getArtifact().equals(artifact) && 
				pair.getLocation().equals(location))
			{
				return false;
			}
		}
		return true;
	}

}
