/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentNewWizard.java,v 1.19 2010/05/05 12:32:44 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

/**
 * <p>Extension of the {@link HyadesNewWizard} wizard for creating deployments.</p>
 *
 * 
 * @author  Marcelo Paternostro
 * @author  Tony Wang
 * @author  Paul E. Slauenwhite
 * @author  Jerome Bozier
 * @version May 4, 2010
 * @since   February 1, 2005
 */
public class DeploymentNewWizard extends HyadesNewWizard {
	
	private DeploymentObjectPage artifactPage = null;
	private DeploymentObjectPage locationPage = null;
	private DeploymentMapPage mapPage = null;
	private TPFDeployment deployment = null;
	private TestLocationPage testLocationPage = null;
	
	/**
	 * Constructor for DeploymentNewWizard
	 */
	public DeploymentNewWizard()
	{
		super();
		setWindowTitle(UiPluginResourceBundle.WIZ_DEPLOY_TTL); 
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWDEPLOYMENT));

		IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard"); //$NON-NLS-1$
		if(settings == null)
			settings = dialogSettings.addNewSection("TestSuiteNewWizard"); //$NON-NLS-1$
		setDialogSettings(settings);
		deployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getLocationPage()
	 */
	protected LocationPage getLocationPage() {
		
		if(testLocationPage == null){

			testLocationPage = new TestLocationPage("deploymentLocation", selection); //$NON-NLS-1$

			String fileExtension = getFileExtension();
			
			if (fileExtension != null) {
				
				testLocationPage.setFileExtension(fileExtension);
				testLocationPage.setFileName(""); //$NON-NLS-1$
			}
		}

		return testLocationPage;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	protected String getFileExtension()
	{
		return ICommonConstants.DEPLOYMENT_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL); 
		getLocationPage().setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_LOC_DSC); 
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL); 
		getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_ATT_DSC); 
		addPage(getAttributeWizardPage());
		
		String[] replacement = new String[]{UiPluginResourceBundle.W_ARTIFACTS};
		artifactPage = new DeploymentObjectPage(NLS.bind(UiPluginResourceBundle.WIZ_DEPLOY_ASSOCIATION, replacement), deployment, Common_ConfigurationFactory.eINSTANCE.createCFGArtifact()); 
		artifactPage.setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL); 
		artifactPage.setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_ART_DSC); 
		addPage(artifactPage);

		replacement = new String[]{UiPluginResourceBundle.W_LOCS};
		locationPage = new DeploymentObjectPage(NLS.bind(UiPluginResourceBundle.WIZ_DEPLOY_ASSOCIATION, replacement), deployment, Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint()); 
		locationPage.setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL); 
		locationPage.setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_LOCATION_DSC); 
		addPage(locationPage);
		
		replacement = new String[]{UiPluginResourceBundle.W_PAIRS};
		mapPage = new DeploymentMapPage(NLS.bind(UiPluginResourceBundle.WIZ_DEPLOY_ASSOCIATION, replacement), deployment); 
		mapPage.setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL); 
		mapPage.setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_MAP_DSC); 
		addPage(mapPage);

	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		Resource resource = createResource(file);
		resource.getContents().add(createEObject());
		EMFUtil.save(resource);
		return true;
	}
	
	/**
	 * Creates the EObject setting the attributes based on the information
	 * the user has defined in this wizard's pages.
	 * @return a not null EObject
	 */
	protected EObject createEObject()
	{
		deployment.setName(getLocationPage().getFileNameWithoutExtension());
		
		String description = getAttributeWizardPage().getItemDescription();
		if((description != null) && (description.trim().length() > 0))
			deployment.setDescription(description);
			
		return deployment;
	}
	
	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	protected Resource createResource(IFile file)
	{
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString(), false);
		Resource.Factory factory = EMFUtil.getResourceFactory(ICommonConstants.DEPLOYMENT_FILE_EXTENSION);
		return factory.createResource(uri);
	}

		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		//Attempt to open the editor:
		TestUIUtil.openEditor(file, TestUIExtension.DEPLOYMENT_EDITOR_PART_ID);		
	}	

	public IWizardPage getNextPage(IWizardPage page)
	{
		mapPage.refresh();
		return super.getNextPage(page);
	}
	
}
