/********************************************************************** 
 * Copyright (c) 2006, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id$ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/**
 * <p>Location host name wizard page.</p>
 * 
 * 
 * @author      Jerome Gout
 * @author 	    Paul E. Slauenwhite
 * @version     April 3, 2009
 * @since       April 10, 2006
 */
public class LocationHostNameWizardPage extends WizardPage {
    
    private Text hostname; 

    public LocationHostNameWizardPage() {
        
        super("locationHostNameWizardPage"); //$NON-NLS-1$
        
        setTitle(UiPluginResourceBundle.LocationHostNameWizardPage_TitlePage);
        setDescription(UiPluginResourceBundle.LocationHostNameWizardPage_DescPage);
    }
    
    public void createControl(Composite parent) {

    	Composite composite = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout(layout);

    	PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, UiPlugin.getID() + ContextIds.LOC_WIZ);

        Label hostLabel = new Label(composite, SWT.NONE);
        hostLabel.setText(UiPluginResourceBundle.LBL_HOST_NME);
        
        hostname = new Text(composite, SWT.BORDER);
        hostname.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
        hostname.addModifyListener(new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                validatePage();
            }
        });
        
		Link testConnectionLink = new Link(composite, SWT.NULL);
		testConnectionLink.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		testConnectionLink.setText("<a>" + UiPluginResourceBundle.TEST_CONNECTION_NAME + "</a>"); 
		testConnectionLink.addSelectionListener(new SelectionAdapter(){
			
			public void widgetSelected(SelectionEvent selectionEvent) {
				TestUIUtilities.testConnection(hostname.getText());
			}
		});

        initControl();
               
        setControl(composite);
    }

    /**
	 * @see org.eclipse.jface.dialogs.DialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {
		
		super.setVisible(visible);
		
		if (visible) {
			 hostname.setFocus();
		}
	}
	
    public String getHostname() {
        if(hostname != null) {
            return hostname.getText();
        } else {
            return UiPlugin.getInstance().getRAServerHost();
        }
    }
   
    protected void initControl() {
        hostname.setText(UiPlugin.getInstance().getRAServerHost());
    }
    
    protected void validatePage() {
        if ("".equals(hostname.getText().trim())) { //$NON-NLS-1$
            setErrorMessage(UiPluginResourceBundle.LocationHostNameWizardPage_ERROR_HostNameEmpty);
            setPageComplete(false);
            return;
        }
        setErrorMessage(null);
        setPageComplete(true);
    }

}
