/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportGeneratorsExtensionRegistryReader.java,v 1.1 2005/03/17 11:19:46 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;

/**
 * @author pnedelec
 *
 */
public class ReportGeneratorsExtensionRegistryReader {
    public static final String PLUGIN_POINT = "reportGenerators"; //$NON-NLS-1$
    public static final String WIZARD = "wizard"; //$NON-NLS-1$
    public static final String ID = "id"; //$NON-NLS-1$
    public static final String NAME = "name"; //$NON-NLS-1$
    public static final String DESCRIPTION = "description"; //$NON-NLS-1$
    public static final String ICON = "icon"; //$NON-NLS-1$

    private static ReportGeneratorsExtensionRegistryReader instance = null;

    public static ReportGeneratorsExtensionRegistryReader getInstance() {
        if (instance == null) {
            instance = new ReportGeneratorsExtensionRegistryReader();
        }
        return instance;
    }

    private List wizards;

    private ReportGeneratorsExtensionRegistryReader() {
        wizards = new LinkedList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(HyadesUIPlugin.getInstance().getBundle().getSymbolicName(), PLUGIN_POINT);
        if (point == null) return;
        IExtension[] extensions = point.getExtensions();
        try {
            for (int i = 0; i < extensions.length; i++) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                for (int j = 0; j < elements.length; j++) {
                    if (elements[j].getName().equals(WIZARD)) {
                        wizards.add(elements[j]);
                    }
                }
            }
        } catch (Exception e) {
            UiPlugin.logError(e);
        }
    }
    
    public List getWizardCategoryElements() {
        return wizards;
    }

}
