/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SUTNewWizard.java,v 1.6 2009/03/27 17:10:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFSUT;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.NameAndDescriptionWizardPage;

/**
 * <p>Wizard for System Under Test (SUT).</p>
 * 
 *
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version March 27, 2009
 * @since   February 1, 2005
 */
 public class SUTNewWizard
extends HyadesWizard
{
	private NameAndDescriptionWizardPage nameAndDescriptionWizardPage;
	
	/**
	 * Constructor for SUTNewWizard
	 */
	public SUTNewWizard()
	{
		super();

		setWindowTitle(UiPluginResourceBundle.WIZ_SUT_TTL); 
	}

	/**
	 * Returns the "name and description page" used by this wizard.
	 * @return NameDescriptionWizardPage
	 */
	protected NameAndDescriptionWizardPage getNameAndDescriptionWizardPage()
	{
		return nameAndDescriptionWizardPage;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
	    nameAndDescriptionWizardPage = new NameAndDescriptionWizardPage("nameDescription"); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages(){
		
		getNameAndDescriptionWizardPage().setTitle(UiPluginResourceBundle.WIZ_SUT_GEN_PG_TTL); 
		getNameAndDescriptionWizardPage().setDescription(UiPluginResourceBundle.WIZ_SUT_GEN_PG_ATT_DSC); 
		
		addPage(getNameAndDescriptionWizardPage());
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		TPFSUT sut = Common_TestprofileFactory.eINSTANCE.createTPFSUT();
		sut.setName(getNameAndDescriptionWizardPage().getItemName());
		sut.setDescription(getNameAndDescriptionWizardPage().getItemDescription());
		
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		testSuite.getSUTs().add(sut);
		
		return true;
	}
}
