/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCaseNewWizard.java,v 1.6 2009/03/27 17:10:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage;
import org.eclipse.ui.INewWizard;

/**
 * <p>The Hyades generic new test case wizard.</p>
 * 
 * 
 * @author  Patrick Nedelec
 * @author  Paul E. Slauenwhite
 * @version March 27, 2009
 * @since   February 1, 2005
 */
 public class TestCaseNewWizard extends HyadesWizard implements INewWizard {
    private TestCaseDefinitionPage testCaseDefinitionPage;
    private SelectionPage selectionPage;

    /**
     * Constructor for TestCaseNewWizard
     */
    public TestCaseNewWizard() {
        super();
        setWindowTitle(UiPluginResourceBundle.WIZ_TST_CASE_TTL); 
        setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWTESTCASE));
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
        testCaseDefinitionPage = new TestCaseDefinitionPage("TestCaseDefinitionPage", getWorkbench(), getSelection()); //$NON-NLS-1$
        selectionPage = new TestCaseSelectionPage("SelectionPage", getWorkbench(), getSelection()); //$NON-NLS-1$
        selectionPage.setTitle(UiPluginResourceBundle.WIZ_TST_CASE_TTL); 
        selectionPage.setDescription(UiPluginResourceBundle.WIZ_SEL_TST_CASE); 
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#addPages()
     */
    public void addPages() {
        addPage(testCaseDefinitionPage);
        addPage(selectionPage);
    }

    /** 
     * @see org.eclipse.jface.wizard.IWizard#canFinish()
     */
    public boolean canFinish() {
        return false;
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#performFinish()
     */
    public boolean performFinish() {
        return true;
    }
}
