/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCaseSelectionPage.java,v 1.6 2009/04/17 00:47:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

/**
 * <p>A page to select which wizard will help the user to create a test case.</p>
 * 
 * 
 * @author  Patrick Nedelec
 * @author  Paul Slauenwhite
 * @version April 16, 2009
 * @since   February 1, 2005
 */
public class TestCaseSelectionPage extends SelectionPage {
    private ITestSuite testSuite;

    /**
     * Constructor
     */
    public TestCaseSelectionPage(String pageName, IWorkbench workbench, IStructuredSelection structuredSelection) {
        super(pageName, workbench, structuredSelection, new IWizardElement[0], UiPluginResourceBundle.WIZ_SEL_TST_CASE_WIZS_LABEL);
        this.testSuite = null;
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage#createWizardNode(org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement)
     */
    protected IWizardNode createWizardNode(IWizardElement wizardElement) {
        IWizardNode wizardNode = (IWizardNode) wizardElement.getAdapter(IWizardNode.class);
        if ((wizardNode != null) && (!wizardNode.isContentCreated())) {
            IWizard wizard = wizardNode.getWizard();
            if (wizard instanceof ITestCaseWizard) {
                if (testSuite != null) {
                    ((ITestCaseWizard) wizard).setTestSuite(testSuite);
                }
                ((IWorkbenchWizard) wizard).init(getWorkbench(), getStructuredSelection());
                wizard.addPages();
            }
        }
        return wizardNode;
    }

    /**
     * Sets the test suite in which the test case will be added.
     * 
     * @param ts
     */
    public void setTestSuite(ITestSuite ts) {
        this.testSuite = ts;
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage#setWizardElements(org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement[])
     */
    public void setWizardElements(IWizardElement[] elements) {
        setErrorMessage(null);
        super.setWizardElements(elements);
        if (elements.length <= 0) {
            if (testSuite != null) {
                String tsType = testSuite.getType();
                setErrorMessage(NLS.bind(UiPluginResourceBundle._ERROR_WIZ_SEL_TST_CASE_EMPTY_WITH_TYPE_MSG, tsType)); 
            } else {
                setErrorMessage(UiPluginResourceBundle._ERROR_WIZ_SEL_TST_CASE_EMPTY_MSG); 
            }
        }
    }

}
