/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestComponentNewWizard.java,v 1.6 2009/03/27 17:10:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.NameAndDescriptionWizardPage;

/**
 * <p>Wizard for Test Component.</p>
 * 
 *
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version March 27, 2009
 * @since   February 1, 2005
 */
public class TestComponentNewWizard
extends HyadesWizard
{
	private NameAndDescriptionWizardPage nameAndDescriptionWizardPage;
	
	/**
	 * Constructor for TestComponentNewWizard
	 */
	public TestComponentNewWizard()
	{
		super();

		setWindowTitle(UiPluginResourceBundle.WIZ_TST_CMP_TTL); 
	}

	/**
	 * Returns the "name and description page" used by this wizard.
	 * @return NameDescriptionWizardPage
	 */
	protected NameAndDescriptionWizardPage getNameAndDescriptionWizardPage()
	{
		return nameAndDescriptionWizardPage;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
	    nameAndDescriptionWizardPage = new NameAndDescriptionWizardPage("nameDescription"); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages(){
		
		getNameAndDescriptionWizardPage().setTitle(UiPluginResourceBundle.WIZ_TST_CMP_GEN_PG_TTL); 
		getNameAndDescriptionWizardPage().setDescription(UiPluginResourceBundle.WIZ_TST_CMP_GEN_PG_ATT_DSC); 
		
		addPage(getNameAndDescriptionWizardPage());
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		TPFTestComponent testComponent = Common_TestprofileFactory.eINSTANCE.createTPFTestComponent();
		testComponent.setName(getNameAndDescriptionWizardPage().getItemName());
		testComponent.setDescription(getNameAndDescriptionWizardPage().getItemDescription());
		
		if(testComponent.getBehaviors().isEmpty())
		{
			TPFBehavior behavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
			testComponent.getBehaviors().add(behavior);
		} 
		
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		testSuite.getTestComponents().add(testComponent);
		
		return true;
	}
}
