/*******************************************************************************
 * Copyright (c) 2007, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.File;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeSelectionDialog;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * <p>TestLogImportWizardPage.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Joseph P. Toomey
 * @version May 4, 2010
 * @since   March 21, 2007
 */
public class TestLogImportWizardPage extends TestLocationPage {

	// TODO: Validation -- ensure all data is valid before enabling finish
	
	protected FileFieldEditor editor;
	protected Button btnDatabase;
	protected Button btnTestSuite;
	protected IFile testSuite;
	protected Text testSuiteText;
	protected Label testSuiteLabel;
	
	public TestLogImportWizardPage(String pageName, IStructuredSelection selection) {
		super(pageName, selection);
		setTitle(pageName);
		setDescription(UiPluginResourceBundle.TestLogImportWizardPage_PAGE_DESCRIPTION);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.common.ui.wizard.LocationPage#createAdvancedControls(org.eclipse.swt.widgets.Composite)
	 */
	protected void createAdvancedControls(Composite parent) {
		Composite fileSelectionArea = new Composite(parent, SWT.NONE);
		GridData fileSelectionData = new GridData(GridData.GRAB_HORIZONTAL
				| GridData.FILL_HORIZONTAL);
		fileSelectionArea.setLayoutData(fileSelectionData);

		GridLayout fileSelectionLayout = new GridLayout();
		fileSelectionLayout.numColumns = 3;
		fileSelectionLayout.makeColumnsEqualWidth = false;
		fileSelectionLayout.marginWidth = 0;
		fileSelectionLayout.marginHeight = 0;
		fileSelectionArea.setLayout(fileSelectionLayout);
		
		editor = new FileFieldEditor("testLogImportFile",UiPluginResourceBundle.TestLogImportWizardPage_SELECT_SOURCE_FILE,fileSelectionArea); //$NON-NLS-1$
		editor.getTextControl(fileSelectionArea).addModifyListener(new ModifyListener(){
			
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
			 */
			public void modifyText(ModifyEvent e) {
				
				String fileName = new Path(editor.getStringValue()).lastSegment();

				if(fileName != null){
					setFileName(fileName);
				}
				else{
					setFileName(""); //$NON-NLS-1$
				}
			}
		});
		String[] extensions = new String[] { "*.testlog" }; //$NON-NLS-1$
		editor.setFileExtensions(extensions);
		editor.getTextControl(fileSelectionArea).addListener(SWT.Modify, this);

		testSuiteLabel = new Label(fileSelectionArea, SWT.LEFT);
		testSuiteLabel.setFont(parent.getFont());
		testSuiteLabel.setText(UiPluginResourceBundle.TestLogImportWizardPage_SELECT_TEST_SUITE);
		testSuiteLabel.addDisposeListener(new DisposeListener() {
            public void widgetDisposed(DisposeEvent event) {
            	testSuiteLabel = null;
            }
        });
		
		testSuiteText = new Text(fileSelectionArea, SWT.BORDER);
		testSuiteText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		testSuiteText.setEditable(false);
		testSuiteText.addListener(SWT.Modify, this);
		
		btnTestSuite = new Button(fileSelectionArea, SWT.PUSH);
		btnTestSuite.setFont(parent.getFont());
		btnTestSuite.setText(UiPluginResourceBundle.TestLogImportWizardPage_BROWSE);
		btnTestSuite.addSelectionListener(new SelectionListener() {

			public void widgetDefaultSelected(SelectionEvent e) {
			}

			public void widgetSelected(SelectionEvent e) {
			    
				ProxyNodeSelectionDialog proxyNodeSelectionDialog = new ProxyNodeSelectionDialog(Display.getCurrent().getActiveShell(), 
						UiPluginResourceBundle.DLG_RESOURCE_SEL, 
						new String[]{ICommonConstants.TEST_SUITE_FILE_EXTENSION}, 
						SWT.RESIZE); 

				if(proxyNodeSelectionDialog.open() == Window.OK){
				
					IProxyNode[] selectedProxyNodes = proxyNodeSelectionDialog.getSelectedProxyNodes();
					
					if(selectedProxyNodes.length > 0){

						IResource resource = selectedProxyNodes[0].getUnderlyingResource();
						
						if(resource instanceof IFile){
						
							testSuite = ((IFile)(resource));
						
							testSuiteText.setText(testSuite.getFullPath().toString());
						
							setPageComplete(validatePage());
						}
					}
				}
			}
		});
        GridData gd = new GridData();
        gd.horizontalAlignment = GridData.FILL;
        btnTestSuite.setLayoutData(gd);
		
        // This feature is not shipping in 4.4.
        // Only create this option is the debug option is set.
		if(ModelDebugger.INSTANCE.debugDatabaseResourcePostfix!=null && 
				   ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length()!=0) 
		{        
			btnDatabase = new Button(fileSelectionArea, SWT.CHECK);
			btnDatabase.setText(UiPluginResourceBundle.TestLogImportWizardPage_IMPORT_INTO_DATABASE);
			btnDatabase.setSelection(false);
		}
		
		fileSelectionArea.moveAbove(null);

	}
	
	protected File getFragmentFile() {
		return new File(editor.getStringValue());
	}
	
	protected boolean isDatabase() {
        // This feature is not shipping in 4.4.
        // Only create this option is the debug option is set.
		if(ModelDebugger.INSTANCE.debugDatabaseResourcePostfix!=null && 
				   ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length()!=0) 
			return btnDatabase.getSelection();
		else
			return false;
	}

	// Strip file extension (loader will concatenate the appropriate .execution 
	// or .executiondb.) 
	public void setFileName(String value) {
		int offset = value.lastIndexOf('.');
		if (offset > 0) {
			value = value.substring(0, offset);
		}
		super.setFileName(value);
	}

	protected IFile getTestSuite() {
		return testSuite;
	}


	protected boolean validatePage() {
		boolean valid = super.validatePage();


		if (valid) {
			File frag = getFragmentFile();
			IPath path = getContainerFullPath();
			valid = (testSuite != null) && (frag != null) && (frag.exists() && path != null);
		}
			
		return valid;
	}
}
