/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BasicTestComponentTabGroup.java,v 1.6 2006/12/15 16:37:58 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.tabGroups;

import java.util.List;

/**
 * <p>Provides the tab group for the Test Component Launch Configurations.<br>
 * In addition to the specification of its parent class
 * {@link org.eclipse.hyades.test.ui.launch.tabGroups.AbstractTabGroup}, this implementation
 * shows a tab that allows the user to select a Test Component within a
 * hierarchical view similar to the Test Navigator logical view, and a Deployment
 * in a list of available deployments for the selected test.</p>
 * <p><b>Note that Test Component UI support is provisional in TPTP 4.0 and is
 * subject to change in future releases.</b></p>
 * @author jcanches
 */
public class BasicTestComponentTabGroup extends AbstractTabGroup {

	/**
	 * Add to the tab list the Hyades Test Component Selection Tab.
	 * @param tabList
	 */
	protected void addRunnableItemSelectionTab(List tabList, String mode) {
		tabList.add(getTabFactory().newTestComponentAndDeploymentTab(mode, _getLaunchConfigurationType()));
	}
	
	protected String getLaunchConfigurationType() {
		return null; // means use basic Launch Configuration Type
	}
}
