/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BasicTestTabGroup.java,v 1.6 2006/12/15 16:37:58 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.tabGroups;

import java.util.List;

/**
 * Provides the tab group for the Test Launch Configurations.<br>
 * In addition to the specification of its parent class
 * {@link org.eclipse.hyades.test.ui.launch.tabGroups.AbstractTabGroup}, this implementation
 * shows a tab that allows the user to select a Test within a
 * hierarchical view similar to the Test Navigator logical view, and a Deployment
 * in a list of available deployments for the selected test.
 * @author jcanches
 */
public class BasicTestTabGroup extends AbstractTabGroup {

	/**
	 * This implementation adds the Test Selection Tab to the list.
	 * @param tabList
	 */
	protected void addRunnableItemSelectionTab(List tabList, String mode) {
		tabList.add(getTabFactory().newTestAndDeploymentTab(mode, _getLaunchConfigurationType()));
	}
		
	protected String getLaunchConfigurationType() {
		return null; // means use basic Launch Configuration Type
	}
}
