/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLaunchConfigurationTabFactory.java,v 1.9 2007/06/04 13:58:49 jptoomey Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.tabGroups;

import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.hyades.test.ui.internal.launch.tabs.ExecutionHistoryTab;
import org.eclipse.hyades.test.ui.internal.launch.tabs.TestAndDeploymentTab;
import org.eclipse.hyades.test.ui.internal.launch.tabs.TestComponentAndDeploymentTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;

/**
 * Factory for creating TPTP-specific launch configuration tabs.
 * As of TPTP 4.3, this factory must be instantiated to create tabs. All tab creation methods
 * are now non-static.
 * @author jcanches
 */
public class TestLaunchConfigurationTabFactory {

	private AbstractTabGroup tabGroup;

	/*package*/ TestLaunchConfigurationTabFactory(AbstractTabGroup tabGroup) {
		this.tabGroup = tabGroup;
	}
	
	/**
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public AbstractTabGroup getTabGroup() {
		return tabGroup;
	}
	
	/**
	 * Creates a new Test & Deployment Selection Tab.
	 * @param mode The run mode (this is used for proposing test elements that support
	 * this mode only). This method may be used in subclasses, but is not meant to be
	 * overrided.
	 * @param launchConfigurationType The launch configuration type. This type is used to determine 
	 * the content of the returned Test tab.
	 * @deprecated Use the non-static version {@link #newTestAndDeploymentTab(String, String)}.
	 */
	public static ILaunchConfigurationTab createTestAndDeploymentTab(String mode, String launchConfigurationType) {
		return new TestAndDeploymentTab(mode, launchConfigurationType, null);
	}
	
	/**
	 * Creates a new Test & Deployment Selection Tab.
	 * @param mode The run mode (this is used for proposing test elements that support
	 * this mode only). This method may be used in subclasses, but is not meant to be
	 * overrided.
	 * @param launchConfigurationType The launch configuration type. This type is used to determine 
	 * the content of the returned Test tab.
	 * @since 4.3.1
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public ILaunchConfigurationTab newTestAndDeploymentTab(String mode, String launchConfigurationType) {
		return new TestAndDeploymentTab(mode, launchConfigurationType, tabGroup);
	}
	
	/**
	 * Creates a new Test Component & Deployment Selection Tab.
	 * @param mode The run mode (this is used for proposing test elements that support
	 * this mode only). This method may be used in subclasses, but is not meant to be
	 * overrided.
	 * @param launchConfigurationType The launch configuration type. This type is used to determine 
	 * the content of the returned Test tab.
	 * @deprecated Use the non-static version {@link #newTestComponentAndDeploymentTab(String, String)}.
	 */
	public static ILaunchConfigurationTab createTestComponentAndDeploymentTab(String mode, String launchConfigurationType) {
		return new TestComponentAndDeploymentTab(mode, launchConfigurationType);
	}
	
	/**
	 * Creates a new Test Component & Deployment Selection Tab.
	 * @param mode The run mode (this is used for proposing test elements that support
	 * this mode only). This method may be used in subclasses, but is not meant to be
	 * overrided.
	 * @param launchConfigurationType The launch configuration type. This type is used to determine 
	 * the content of the returned Test tab.
	 * @since 4.3.1
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public ILaunchConfigurationTab newTestComponentAndDeploymentTab(String mode, String launchConfigurationType) {
		return new TestComponentAndDeploymentTab(mode, launchConfigurationType);
	}
	
	/**
	 * Creates a new Test Log Tab.
	 * @param launchConfigurationType The launch configuration type. This type is used to determine 
	 * the content of the returned Test Log tab.
	 * @deprecated Use the non-static version {@link #newTestLogTab(String)}.
	 */
	public static ILaunchConfigurationTab createTestLogTab(String launchConfigurationType) {
		return new ExecutionHistoryTab(launchConfigurationType, null);
	}
	
	/**
	 * Creates a new Test Log Tab.
	 * @param launchConfigurationType The launch configuration type. This type is used to determine 
	 * the content of the returned Test Log tab.
	 * @since 4.3.1
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public ILaunchConfigurationTab newTestLogTab(String launchConfigurationType) {
		return new ExecutionHistoryTab(launchConfigurationType, tabGroup);
	}
	
	/**
	 * Creates a new Profiling Tab.
	 * @param attach If <code>false</code>, the returned tab should display the
	 * auto-attach option. If <code>true</code>, this option should not be displayed and
	 * the profiler should automatically attach to the process.
	 * @deprecated This factory does not allow Profiling tabs creation any more. See
	 * org.eclipse.hyades.trace.ui for equivalent feature.
	 */
	public static ILaunchConfigurationTab createProfilingTab(boolean attach) {
		return new ProfileTab(false);
	}
	
}
