/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AbstractProxy.java,v 1.1 2008/03/20 19:49:53 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IResource;

/**
 * Partial implementation of the IProxy interface that manages the <code>equals</code> and <code>hashcode</code> methods.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.5
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public abstract class AbstractProxy implements IProxy {

	public boolean equals(Object arg0) {
		if(arg0 instanceof IProxy) {
			IResource resThis=this.getUnderlyingResource();
			IResource resArg = ((IProxy)arg0).getUnderlyingResource();
			String idThis = this.getIdentifier();
			String idArg = ((IProxy)arg0).getIdentifier();
			return ((resThis != null && resThis.equals(resArg)) || (resThis == null && resArg == null)) 
				&& ((idThis != null && idThis.equals(idArg)) || (idThis == null && idArg == null));
		}
		return false;
	}

	public int hashCode() {
		IResource resThis=this.getUnderlyingResource();
		return resThis != null ? resThis.hashCode() :  -1;
	}
}
