/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTypedElementProxyFactory.java,v 1.4 2006/02/13 21:18:53 mddunn Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestComponentlProxyNode;
import org.eclipse.ui.IMemento;

/**
 * Factory used to create default proxies for typed elements
 * Clients may extend this class and override only the methods 
 * that should not create the default proxy nodes.
 * @author jgout
 * @since 4.0
 */
public class DefaultTypedElementProxyFactory implements IPersistableTypedElementProxyFactory {
	
	/**
	 * @see org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory#recreate(org.eclipse.ui.IMemento, java.lang.Object)
	 */
	public IProxyNode recreate(IMemento memento, Object parent) {
		String nodeKind = memento.getString(TestUIConstants.TAG_NODE_KIND);
		if(nodeKind.equals(TestUIConstants.TESTSUITE_NODE)) {
			return new DefaultTestSuiteProxyNode(memento, parent);
		} else if(nodeKind.equals(TestUIConstants.TESTCASE_NODE)) {
			return new DefaultTestCaseProxyNode(memento, parent);
		} else if(nodeKind.equals(TestUIConstants.EXECUTION_RESULT_NODE)) {
			return new DefaultExecutionResultProxyNode(memento, parent);
		} else if(nodeKind.equals(TestUIConstants.TESTCOMPONENT_NODE)) {
			return new DefaultTestComponentlProxyNode(memento, parent);
		}
		return null;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory#create(org.eclipse.hyades.models.common.testprofile.TPFExecutionResult, java.lang.Object)
	 */
	public IProxyNode create(TPFExecutionResult result, Object parent) {
		return new DefaultExecutionResultProxyNode(result, parent);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory#create(org.eclipse.hyades.models.common.testprofile.TPFTest, java.lang.Object)
	 */
	public IProxyNode create(TPFTest test, Object parent) {
		if(test instanceof TPFTestSuite) {
			return new DefaultTestSuiteProxyNode((TPFTestSuite)test, parent);
		} else if(test instanceof TPFTestCase) {
			return new DefaultTestCaseProxyNode((TPFTestCase)test, parent);
		} else return null;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory#create(org.eclipse.hyades.models.common.testprofile.TPFTestComponent, java.lang.Object)
	 */
	public IProxyNode create(TPFTestComponent component, Object parent) {
		return new DefaultTestComponentlProxyNode(component, parent);
	}
}