/*
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditorIdFactory.java,v 1.1 2005/05/25 17:53:25 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.UiPlugin;


/**Singleton class which provides the editor ids for the file extensions.
 * @author george.sebastian@ca.com
 * //added for for bugzilla #95329 - george.sebastian@ca.com
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EditorIdFactory  implements IEditorIdFactory {
	
	private static EditorIdFactory editorIdFactory;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.navigator.IEditorIdFactory#getEditorId(org.eclipse.core.resources.IFile)
	 */
	public  String getEditorId(IFile file) {
		
		Map editorMappings = null;
		
		String extension = null;
		
		if(file!=null){
			extension= file.getFileExtension();	
		}
		
		String editorId = "";
		
		if(extension != null){
			editorMappings = UiPlugin.getInstance().getEditorMappings();
			if (null!= editorMappings.get(extension)){
				editorId = editorMappings.get(extension).toString();
			}
			return editorId;
		}else
		return editorId ;			
	}
	

	/*Returns the instance of an EditorId factory.
	 * 
	 */
	public static EditorIdFactory getInstance(){
		
		if (editorIdFactory == null){
			editorIdFactory = new EditorIdFactory();
		}
		
		return editorIdFactory;
	}
	

}
