/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionResultProxyNode.java,v 1.4 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;

/**
 * Test log (aka execution result) proxy node.
 * This interface should be used in order to implement <code>TPFExecutionResult</code> proxy node for the test navigator.
 * 
 * @see org.eclipse.hyades.models.common.testprofile.TPFExecutionResult
 * @author jgout
 */
public interface IExecutionResultProxyNode extends ITypedElementProxyNode {
	
    /**
     * Returns the underlying test model element which is a <code>TPFExecutionResult</code> instance.
     * @return the test log associated to this proxy node.
     */
	public TPFExecutionResult getExecutionResult();

    /**
     * Returns the verdict associated to the execution result.
     * @return integer value among ones defined by TPFVerdict (e.g. TPFVerdict.ERROR)
     * @see org.eclipse.hyades.models.common.testprofile.TPFVerdict 
     */
    public int getVerdict();
}
