/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFileProxyFactory.java,v 1.5 2008/03/20 19:49:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;

/** Factory interface to produce a proxy from a file.
 *  Implementation of this interface should be used in the following extension point: 
 * <p><code>org.eclipse.hyades.test.ui.testNavigatorFileProxyFactory</code></p>
 * @author jgout
 * @version February 26, 2008
 * @since 3.2
 */
public interface IFileProxyFactory {
	
	/** Create a proxy node fromt the given file.
	 * @param file the file to convert in proxy.
	 * @param parent an existing object (proxy node or not) which is the parent of the file proxy node in the proxy node hierarchy.
	 * @return a proxy which is used in the test navigator instead of the file itself.
	 * The returned node must meet the following condition:
	 * <code>file.equals(factory.create(file, parent).getAdapter(IFile.class))</code>
	 */
	public IProxyNode create(IFile file, Object parent);
	
}
