/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPersistableFileProxyFactory.java,v 1.4 2008/03/20 19:49:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IMemento;

/** 
 * Interface for factories that can handle the persistancy of created proxy nodes.
 * @author jgout
 * @version February 26, 2008
 * @since 3.3
 */
public interface IPersistableFileProxyFactory extends IFileProxyFactory {
    
	/**
     * Returns the proxy node built based on the content of the given memento.
     * The proxy node returned is used instead of the given file in the test navigator.
     * 
     * @param memento The content of the proxy persisted.  
     * @param file The file that the proxy node is the placeholder.
     * @param parent The parent of the new created proxy node in the test navigator. 
     * @return The proxy node built based on the content of the given memento.
	 * The returned node must meet the following condition:
	 * <code>file.equals(factory.create(file, parent).getAdapter(IFile.class))</code>
	 */
	public IProxyNode recreate(IMemento memento, IFile file, Object parent);
	
}
