/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPersistableProxyNode.java,v 1.3 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.ui.IMemento;

/**
 * Persitable proxy node.
 * Clients of this interface should implement this interface in order 
 * to persist the content of a proxy node to avoid its creation at the start time of the workbench or when the test navigator is re-open.  
 * 
 * @author jgout
 */
public interface IPersistableProxyNode extends IProxyNode {
	
	/**
	 * Returns the id of the factory that is able to recreate this proxy node starting to a save state.
     * This id is declared in both extension:
     * <ul>
     * <li><code>org.eclipse.hyades.test.ui.testNavigatorFileProxyFactory</code></li>
     * <li><code>org.eclipse.hyades.test.ui.testNavigatorTypedElementProxyFactory</code></li>
     * </ul>
     * @return a proxy node factory id.
	 */
    public String getFactoryID();
	
    /**
     * Save the content of the current proxy node in the given memento object.
     * @param memento the memento in which the state of the current proxy node should be added.
     * @return the returned value is no longer significant.
     */
	public boolean saveState(IMemento memento);

}
