/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPersistableTypedElementProxyFactory.java,v 1.3 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.ui.IMemento;

/**
 * Interface for factories that can handle the persistancy of created proxy nodes.
 * @author jgout
 * @since 3.3
 */
public interface IPersistableTypedElementProxyFactory extends ITypedElementProxyFactory {

	/**
     * Returns the proxy node built based on the content of the given memento.
	 * @param memento The content of the proxy persisted.  
	 * @param parent the parent object of the new typed element proxy node.
	 * @return proxy a new typed element proxy node instance loaded based on the content of the given memento.
	 */
	public IProxyNode recreate(IMemento memento, Object parent);
	
	
}
