/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProxy.java,v 1.2 2008/03/20 19:49:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IResource;

/**
 * Lightweight object that represents an arbitrary element within a resource.
 * Two instances of this class should be equal if and only if they have equal
 * underlying resource and identifier.
 * @author jcanches
 * @version February 26, 2008
 * @since 4.0
 */
public interface IProxy {
	
	/** Returns the file system resource containing the element represented by this proxy.
	 * @return the file system resource containing the element represented by this proxy.
	 */
	public IResource getUnderlyingResource();

	/** Returns a unique identifier for the represented element within the underlying resource. 
	 *  If two instances of IProxy have the same identifier for the same underlying resource,
	 *  this means that those proxies designate the same element.
	 * @return an string that identify the element in its underlying resource. 
	 */
	public String getIdentifier();

}