/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProxyNode.java,v 1.5 2008/03/20 19:49:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;

/**
 * Main interface to wrap objects into the test navigator.
 * Instances of this interface must meet the following condition:
 * <code>getAdapter(IFile.class) == null || getAdapter(IFile.class) == getUnderlyingResource() </code>
 * 
 * @author jgout
 * @version February 26, 2008
 */
public interface IProxyNode extends IAdaptable, IProxy {

	/** Returns the label used in the navigator to designate this node.
	 * @return the name of the node.
	 */
	public String getText();

	/** Returns the icon of this node used in the navigator.
	 * @return the icon of this node.
	 */
	public Image getImage();
	
	/** Returns the parent object of this node.
	 * @return the parent of this node.
	 */
	public Object getParent();
	
	/** Returns the array of children of this node. Children are proxies also.
	 * @return the array of children of this node.
	 */
	public IProxyNode[] getChildren();
	
}
