/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProxyNodeListener.java,v 1.2 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

/** 
 * Test Navigator node listener.
 * This interface can be call to notify that a given node has changed and so the test navigator is supposed to be refreshed.
 * @author jgout
 * @since 4.0
 * 
 */
public interface IProxyNodeListener {
    
    /**
     * Notification that the given node (proxy node or not) has changed.
     * @param node the node that has changed.
     */
    public void nodeChanged(Object node);
    
}
