/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProxyRefreshListener.java,v 1.1 2009/04/16 13:20:16 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

/**
 * Listener that want to register to ProxyRequestManager have to implement this interface 
 * to be called when proxy refresh start or ends inside test navigator
 * @version April 14, 2009
 * @author jbozier
 * @since 4.6
 * @provisional Provisional API as of TPTP 4.6.0.
 *
 */
public interface IProxyRefreshListener {

	/**
	 * called when refresh starts
	 */
	public void start();
	
	/**
	 * called when refresh ends
	 */
	public void end();
}
