/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IRefactoringTransaction.java,v 1.1 2008/03/20 19:49:53 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

/**
 * Some refactoring operations need to perform its change in a global context.
 * This interface allows to declare contexts for grouping refactoring change.
 * This interface is used in the extension point 
 * <code>org.eclipse.hyades.test.ui.testNavigatorRefactoringTransactions</code>.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.5
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public interface IRefactoringTransaction {

	/**
	 * Starts the refactoring transaction.
	 * Implementors can use this method to initialize internal data.
	 * @param pm a progress monitor, or <code>null</code> if progress reporting is not desired.
	 */
	public void beginChanges(IProgressMonitor pm);

	/**
	 * Method called if the transaction is cancelled.
	 * Implementors can use this method to dispose internal data.
	 * @param pm a progress monitor, or <code>null</code> if progress reporting is not desired.
	 */
	public void cancelChanges(IProgressMonitor pm);

	/**
	 * Performs changes.
	 * @return the undo change that is composed of all committed changes or <code>null</code> if undo change is not possible.
	 * @param pm a progress monitor, or <code>null</code> if progress reporting is not desired.
	 * @throws <code>CoreException</code> if the operation failed.
	 */
	public Change commitChanges(IProgressMonitor pm) throws CoreException;
}
