/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IReferencerProxyNode.java,v 1.1 2008/03/20 19:49:53 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import java.util.Collection;
import java.util.Set;

/**
 * Interface to set references between proxy nodes.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.5
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public interface IReferencerProxyNode extends IProxyNode {	
	/**
	 * Gets the reference collection of the given type. The content of this list is populated using {@link addReference} or {@link addBidirectionalReference}.
	 * @param refType the type of the reference to retrieve.
	 * @return a collection containing all the references (IProxyNode) of the 
	 * given type found in the current implementor. An empty 
	 * collection is returned in case of no such typed reference has been found.
	 */
	public Collection getReferences(String refType);
	
	/**
	 * Returns the set of the reference types (as <code>String</code>) contained in the implementor proxy node.
	 * @return the set of the reference types (as <code>String</code>) contained in the implementor proxy node.
	 */
	public Set getReferenceTypes();
	
}
