/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IResourceChangeListenerProxyNode.java,v 1.1 2005/05/20 16:29:47 jgout Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IResourceDelta;

/**
 * Proxy node with the added capability of reacting to resource changes.
 * This class is used by TestFolderProxyNode for representing child folders.
 * @author jgout
 * @since 4.0
 * @see org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode#createChildFolderProxyNode(IContainer)
 */
public interface IResourceChangeListenerProxyNode  extends IProxyNode {

    /**
     * Examines the resource delta and perform any consequent adjustment.
     * @param rootDelta the delta describing the change about the resource represented by this proxy.
     * @return the innermost proxy node in this proxy node hierarchy enclosing all proxy node changes.
     */
    public IProxyNode resourceChanged(IResourceDelta rootDelta);

}