/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestCaseProxyNode.java,v 1.3 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTestCase;

/**
 * Test case proxy node.
 * This interface should be used to wrap a test case element (instance of <code>TPFTestCase</code>).
 * @see org.eclipse.hyades.models.common.testprofile.TPFTestCase
 * @author jgout
 */
public interface ITestCaseProxyNode extends ITypedElementProxyNode {
	
    /**
     * Returns the underlying test model element. This should be an instance of <code>TPFTestCase</code>.
     * @return the test case associated to the current proxy node.
     */
	public TPFTestCase getTestCase();
}
