/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestComponentProxyNode.java,v 1.3 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;

/**
 * Test component proxy node.
 * This interface should be used to wrap a test component element (instance of <code>TPFTestComponent</code>)
 * @see org.eclipse.hyades.models.common.testprofile.TPFTestComponent
 * @author jgout
 */
public interface ITestComponentProxyNode extends ITypedElementProxyNode {
    
    /**
     * Returns the underlying test model element. This should be an instance of <code>TPFTestComponent</code>.
     * @return the test component associated to the current proxy node.
     */
	public TPFTestComponent getTestComponent();
}
