/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;

/** This interface should be used to validate the content of a test folder proxy node.
 * @author jgout
 * @since 4.0
 * @see org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode
 */
public interface ITestFolderContentValidator {
	
	/** Returns whether the file found in the test folder should be converted into a proxy file.
	 *  <br>Some implementors would be able to do some filtering on files to process.
	 *  Eg. AssetGroupProxyNode filter files on thier name extension in order to group files by knid. 
	 * @param file to check.
	 * @return <code>true</code> if the file can be converted to proxy and <code>false</code> otherwise. 
	 */
	public boolean isFileOk(IFile file);

	/** Returns whether the derived proxy from a file found in the test folder should be kept as a child of the test folder or not.
	 * <br>Some subclasses would be able to override this behavior in order to implement a special filtering on the content of a group proxy.
	 * @param node the proxy to check.
	 * @return <code>true</code> if the proxy can be inserted as a child of the test folder and <code>false</code> otherwise.
	 */
	public boolean isProxyOk(IProxyNode node);
	
}