/********************************************************************** 
 * Copyright (c) 2005, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id$ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * <p>Interface for the Test Navigator.</p>
 *
 * <p>This interface is not intended to be used by clients.</p>
 *
 *
 * @author  Jerome Gout
 * @author  Paul Slauenwhite
 * @version April 23, 2009
 * @since   February 1, 2005
 */
public interface ITestNavigator {
    
    public static final String ID = "org.eclipse.hyades.test.ui.TestNavigator"; //$NON-NLS-1$

    public static final String CONTEXT_ID = "org.eclipse.hyades.test.ui.testNavigatorContext"; //$NON-NLS-1$

    /**
     * Returns the current selection.
     * @return a not <code>null</code> IStructuredSelection.
     */
    public IStructuredSelection getStructuredSelection();
    
    /**
     * Sets the current selection and forces to show it. 
     * @param selection the new selection of the test navigator. 
     */
    public void selectReveal(ISelection selection);
}