/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestSuiteProxyNode.java,v 1.3 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * Test Suite proxy node.
 * This interface should be used to wrap a test suite element (instance of <code>TPFTestSuite</code>)
 * @see org.eclipse.hyades.models.common.testprofile.TPFTestSuite
 * @author jgout
 */
public interface ITestSuiteProxyNode extends ITypedElementProxyNode {
    
    /**
     * Returns the underlying test model element. This should be an instance of <code>TPFTestSuite</code>.
     * @return the test suite associated to the current proxy node.
     */
	public TPFTestSuite getTestSuite();
}
