/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITypeProvider.java,v 1.7 2007/05/03 17:35:15 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IProject;

/** 
 * Type providers are responsible to collect and organize all elements of a given type
 * located in a project. The returned node is shown in the logical view of the test navigator. 
 * The returned proxy nodes lifecyle is under the type provider responsibility. If the type provider
 * implements the {@link org.eclipse.hyades.ui.util.IDisposable} interface, the {@link org.eclipse.hyades.ui.util.IDisposable#dispose()} will
 * be invoked when the provider is no longer necessary.
 * From a performance perspective, it is better for a type provider implementation to cache
 * its returned values, unless their computing is trivial.
 * Type providers also have the responsibility of providing updates of their content by
 * using the provided context's {@link IProxyNodeListener}.
 *  
 * @author jgout
 * @since 4.0
 */
public interface ITypeProvider /*extends org.eclipse.hyades.ui.util.IDisposable*/ {
    
    /**
     * Initializes the type provider with a context.
     * @param context The context in which the type provider will be used. The context
     * provides various tools and information for the provider to interact with its
     * context.
     */
    public void init(ITypeProviderContext context);

	/**
	 * Returns a proxy node hierarchy based of the given type from elements located in the given project.
	 * The returned hierarchy will appear as a special type provider node directly under the project.
	 * The implementation should not assume anything about the thread it will run in. This method
	 * may be invoked from any thread, and concurrent calls to this method may happen. However
	 * there will never be two concurrent calls for the same project.
	 * @param project the owner of the returned hierarchy. 
	 * @param type the type of elements that type provider is interested in.
	 * @return a proxy node tree that represents all elements of the given type contained by the given project.
	 */
	public ITypeProviderProxyNode get(IProject project, String type);

    //TODO: uncomment the following line when API can be changed 4.3
//    public void dispose();
    
}
