/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ITypeProviderContext.java,v 1.6 2006/10/27 18:59:10 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.navigator;


/** 
 * Context interface passed to the initialization method of <code>ITypeProvider</code>.
 * This interface is not meant to be implemented by clients.
 * 
 * @author jgout
 * @since 4.0
 */
public interface ITypeProviderContext {
    
    /** 
     * Returns the file proxy manager that is used into the type provider to handle proxies.
     * @return a file proxy manager instance.
     */
    public IFileProxyManager getFileProxyManager();

	/**
	 * Returns an instance of a node listener. The TypeProvider is responsible of notifying
	 * this listener whenever a node or its content has changed. This is needed to
	 * ensure that the TestNavigator is up-to-date as soon as the change occurs.
	 * @return
	 */
	public IProxyNodeListener getProxyNodeListener();
	
	/**
	 * Determines whether the type provider should provide a static view of its content,
	 * i.e. it should provide a tree that is complete and accurate at the time a proxy
	 * node is requested. Also, the provider is not held to provide update events to the
	 * IProxyNodeListener when it appears in a static view.
	 * @return
	 */
	public boolean isStaticView();
	
}
