/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITypedElementProxyFactory.java,v 1.2 2005/02/25 22:17:55 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;

/** Factory for typed elements.
 * <ul>This includes at the moment: </ul>
 * <li>implementation of <code>TPFTest</code></li>
 * <li>implementation of <code>TPFExecutionResult</code></li>
 * <li>implementation of <code>TPFTestComponent</code></li>
 * </ul>
 * Implementation of this interface should be used in the following extension point: 
 * <p><code>org.eclipse.hyades.test.ui.testNavigatorTypedElementProxyFactory</code></p>
 * @author jgout
 */
public interface ITypedElementProxyFactory {
	
	/** Create a proxy node from a test element, mainly:
	 * <li><code>TPFTestSuite</code></li> 
	 * <li><code>TPFTestCase</code></li> 
	 * @param test the element to convert from.
	 * @param parent the parent of the new proxy.
	 * @return the new proxy that represents the given test element in the navigator.
	 */
	public IProxyNode create(TPFTest test, Object parent);
	
	/** Create a new proxy node from an execution result.
	 * @param result the execution result to convert from.
	 * @param parent the parent of the new proxy.
	 * @return the new proxy that represents the given execution result element in the navigator.
	 */
	public IProxyNode create(TPFExecutionResult result, Object parent);
	
	/** Create a new proxy node from a test component.
	 * @param component the test component to convert from.
	 * @param parent the parent of the new proxy.
	 * @return the new proxy that represents the given test component element in the navigator.
	 */
	public IProxyNode create(TPFTestComponent component, Object parent);
	
}
