/*******************************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestNavigatorFilter.java,v 1.1 2010/05/05 20:42:47 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.jface.viewers.IFilter;

/**
 * <p>Implementation of the {@link IFilter} interface to wrap the Test Navigator 
 * filter(s) for to viewers.</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version May 5, 2010
 * @since   May 5, 2010
 * @see     IFilter
 * @see     IFilter
 * @provisional As of TPTP V4.7.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public class TestNavigatorFilter implements IFilter {

	/**
	 * <p>No-argument constructor.</p>
	 */
	public TestNavigatorFilter(){
		//No-operation.
	}
		
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IFilter#select(java.lang.Object)
	 */
	public boolean select(Object object){
		return(!TestNavigator.getFiltersManager().filter(object));
	}
}
