/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypedElementProxyNode.java,v 1.6 2008/03/20 19:49:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.ui.IMemento;

/** General proxy for typed element. 
 *  This class is derived for test suite, test case, test component and execution result
 * @author jgout
 * @version February 26, 2008
 */
public abstract class TypedElementProxyNode extends CMNNamedElementProxyNode implements ITypedElementProxyNode {
	
	private static final String TAG_TYPE = "type"; //$NON-NLS-1$
	
	private String type; 
	
    /**
     * Constructor using test suite and test case objects.
     * @param test a test suite or a test case element.
     * @param parent the parent node of the new proxy node.
     */
	public TypedElementProxyNode(TPFTest test, Object parent) {
		super(test, parent);
		type = test.getType();
	}
	
	/**
     * Constructor using test log.
	 * @param exec a test log
	 * @param parent the parent node of the new proxy node.
	 */
	public TypedElementProxyNode(TPFExecutionResult exec, Object parent) {
		super(exec, parent);
		type = exec.getType();
	}
	
	/**
     * Constructor using test component.
	 * @param testComponent a test component.
	 * @param parent the parent node of the new proxy node.
	 */
	public TypedElementProxyNode(TPFTestComponent testComponent, Object parent) {
		super(testComponent, parent);
		type = testComponent.getType();
	}
	
	/**
     * Constructor to recreate a presisted proxy node.
	 * @param memento the saved proxy node content state.
	 * @param parent the parent node of the new proxy node.
	 */
	public TypedElementProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
		this.type = memento.getString(TAG_TYPE);
		if (this.type == null) {
			throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve type field"); //$NON-NLS-1$
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode#getType()
	 */
	public String getType() {
		return type;
	}
	
    /**
     * @see org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode#saveState(org.eclipse.ui.IMemento)
     * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
     */
    public boolean saveState(IMemento memento) {
		if (this instanceof IPersistableProxyNode) {
			//- data from TypedElementProxyNode
			memento.putString(TAG_TYPE, getType());
			return super.saveState(memento);
		}
		return false;
	}
}
